<?php
/******************************************************************************************
 * Copyright (C) Smackcoders. - All Rights Reserved under Smackcoders Proprietary License
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * Proprietary and confidential
 * You can contact Smackcoders at email address info@smackcoders.com.
 *******************************************************************************************/

namespace Smackcoders\WCSV;

if ( ! defined( 'ABSPATH' ) )
exit; // Exit if accessed directly

class CoreFieldsImport {
	private static $core_instance = null,$media_instance,$nextgen_instance;
	public $detailed_log;

	public static function getInstance() {
		if (CoreFieldsImport::$core_instance == null) {
			CoreFieldsImport::$core_instance = new CoreFieldsImport;
			CoreFieldsImport::$media_instance = new MediaHandling;
			CoreFieldsImport::$nextgen_instance = new NextGenGalleryImport;
			return CoreFieldsImport::$core_instance;
		}
		return CoreFieldsImport::$core_instance;
	}

	function set_core_values($header_array ,$value_array , $map , $type , $mode , $line_number , $unmatched_row, $check , $hash_key,$acf,$pods, $toolset, $update_based_on, $gmode, $variation_count, $wpml_array = null,$templatekey = null){	
		global $sitepress;			
		global $wpdb;
		$get_result = "";
		$post_id = null;
		$helpers_instance = ImportHelpers::getInstance();
		CoreFieldsImport::$media_instance->header_array = $header_array;
		CoreFieldsImport::$media_instance->value_array = $value_array;
		$log_table_name = $wpdb->prefix ."import_detail_log";
		$media_handle = get_option('smack_image_options');

		$unikey_name = 'hash_key';
		$unikey_value = $hash_key;

		if($gmode == 'CLI'){ //Exchange the hashkey value with template key
			$unikey_name = 'templatekey';
			$unikey_value = ($templatekey != null) ? $templatekey : '';
		}	

		$updated_row_counts = $helpers_instance->update_count($unikey_value,$unikey_name);
		$created_count = $updated_row_counts['created'];
		$updated_count = $updated_row_counts['updated'];
		$skipped_count = $updated_row_counts['skipped'];
		
		$taxonomies = get_taxonomies();
			
		if (in_array($type, $taxonomies)) {
			$get_import_type = 'term';
		}elseif ($type == 'Users') {
			$get_import_type = 'user';
		}elseif ($type == 'Comments') {
			$get_import_type = 'comment';
		} else {	
			$get_import_type = 'post';
		}

		if (in_array($type, $taxonomies)) {

			$import_type = $type;
			if($import_type == 'category' || $import_type == 'product_category' || $import_type == 'product_cat' || $import_type == 'wpsc_product_category' || $import_type == 'event-categories'):
				$type = 'Categories';
			elseif($import_type == 'product_tag' || $import_type == 'event-tags' || $import_type == 'post_tag'):
				$type = 'Tags';
		else:
			$type = 'Taxonomies';
			endif;
		}
		
		if(($type == 'WooCommerce Product Variations' ) || ($type == 'WooCommerce Orders') || ($type == 'WooCommerce Coupons') || ($type == 'WooCommerce Refunds') || ($type == 'WooCommerce Attributes') || ($type == 'WooCommerce Tags') || ($type == 'WooCommerce Product') || ($type == 'Categories') || ($type == 'Tags') || ($type == 'Taxonomies') || ($type == 'Comments') || ($type == 'Users') || ($type == 'Customer Reviews') || ($type == 'WPeCommerce Products') || ($type == 'WPeCommerce Coupons') || ($type == 'lp_order')  || ($type == 'nav_menu_item') || ($type == 'widgets')){
			$woocommerce_core_instance = WooCommerceCoreImport::getInstance();
			$taxonomies_instance = TaxonomiesImport::getInstance();
			$users_instance = UsersImport::getInstance();
			$comments_instance = CommentsImport::getInstance();
			$wpecommerce_instance = WPeCommerceImport::getInstance();
			$customer_reviews_instance = CustomerReviewsImport::getInstance();
			$learnpress_instance = LearnPressImport::getInstance();
			$post_values = [];
			$post_values = $helpers_instance->get_header_values($map , $header_array , $value_array);
			
			
			$wpml_values = $helpers_instance->get_header_values($wpml_array , $header_array , $value_array);
			if($type == 'WooCommerce Product'){
				$result = $woocommerce_core_instance->woocommerce_product_import($post_values , $mode , $type, $unmatched_row, $check , $unikey_value , $unikey_name, $line_number, $acf ,$pods, $toolset,$header_array, $value_array,  $wpml_values);				
			}
			if($type == 'WooCommerce Orders'){
				$result = $woocommerce_core_instance->woocommerce_orders_import($post_values , $mode , $check , $unikey_value ,$unikey_name, $line_number);
			}
			if($type == 'WooCommerce Product Variations'){
				$result = $woocommerce_core_instance->woocommerce_variations_import($post_values , $mode , $check ,$unikey_value ,  $unikey_name, $line_number, $variation_count);
			}
			if($type == 'WooCommerce Coupons'){
				$result = $woocommerce_core_instance->woocommerce_coupons_import($post_values , $mode , $check , $unikey_value , $unikey_name, $line_number);
			}
			if($type == 'WooCommerce Refunds'){
				$result = $woocommerce_core_instance->woocommerce_refunds_import($post_values , $mode , $check , $unikey_value , $unikey_name, $line_number);
			}
			if($type == 'WooCommerce Attributes'){
				$result = $woocommerce_core_instance->woocommerce_attributes_import($post_values , $mode , $check ,$unikey_value , $unikey_name, $line_number);
			}
			if($type == 'WooCommerce Tags'){
				$result = $woocommerce_core_instance->woocommerce_tags_import($post_values , $mode , $check , $unikey_value , $unikey_name, $line_number);
			}

			if(($type == 'Categories') || ($type == 'Tags') || ($type == 'Taxonomies') ){
				$result = $taxonomies_instance->taxonomies_import_function($post_values , $mode , $import_type , $unmatched_row, $check , $hash_key , $templatekey, $line_number ,$header_array ,$value_array,$wpml_array,$gmode);
			}
			if($type == 'Users'){
				$result = $users_instance->users_import_function($post_values , $mode ,$unikey_value , $unikey_name, $line_number);
			}
			if($type == 'Comments'){
				$result = $comments_instance->comments_import_function($post_values , $mode ,$unikey_value , $unikey_name, $line_number);
			}
			if($type == 'WPeCommerce Products'){
				$result = $wpecommerce_instance->wpecommerce_product_import($post_values , $mode , $check , $unikey_value , $unikey_name, $line_number);
			}
			if($type == 'WPeCommerce Coupons'){
				$result = $wpecommerce_instance->wpecommerce_coupons_import($post_values , $mode ,$unikey_value , $unikey_name, $line_number);
			}
			if($type == 'Customer Reviews'){
				$result = $customer_reviews_instance->customer_reviews_import($post_values , $mode ,$unikey_value , $unikey_name, $line_number);
			}
		
			if($type == 'lp_order'){
				$result = $learnpress_instance->learnpress_orders_import($post_values , $mode , $check, $unikey_value , $unikey_name, $line_number);
			}

			if($type == 'nav_menu_item'){
				$comments_instance->menu_import_function($post_values , $mode ,$unikey_value , $unikey_name, $line_number);
			}

			if($type == 'widgets'){
				$comments_instance->widget_import_function($post_values , $mode ,$unikey_value , $unikey_name, $line_number);
			}
			$post_id = isset($result['ID']) ? $result['ID'] :'';
			
			if($gmode != 'CLI')
				$helpers_instance->get_post_ids($post_id ,$hash_key);

			if($media_handle['media_settings']['media_handle_option'] == 'true' && !empty($post_values['featured_image'])){
				update_option('ultimate_csv_importer_pro_featured_image', $post_values['featured_image']);
			}

			if(isset($post_values['featured_image'])) {	
				if ( preg_match_all( '/\b[-A-Z0-9+&@#\/%=~_|$?!:,.]*[A-Z0-9+&@#\/%=~_|$]/i', $post_values['featured_image'], $matchedlist, PREG_PATTERN_ORDER ) ) {	
					if($media_handle['media_settings']['media_handle_option'] == 'true' ){
						$post_values['featured_image'] = $this->check_for_featured_image_url($post_values['featured_image']);
						$attach_id = $this->featured_image_handling($media_handle, $post_values, $post_id, $type, $get_import_type, $unikey_value, $unikey_name, $header_array, $value_array,$hash_key,$templatekey);
					}	
				}
			}
			
			if(preg_match("(Can't|Skipped|Duplicate)", $this->detailed_log[$line_number]['Message']) === 0) {  
				if ( $type == 'WooCommerce Product' || $type == 'WPeCommerce Products') {
					if ( ! isset( $post_values['post_title'] ) ) {
						$post_values['post_title'] = '';
					}
					$this->detailed_log[$line_number]['VERIFY'] = "<b> Click here to verify</b> - <a href='" . get_permalink( $post_id ) . "' target='_blank' title='" . esc_attr( sprintf( __( 'View &#8220;%s&#8221;' ), $post_values['post_title'] ) ) . "'rel='permalink'>Web View</a> | <a href='" . get_edit_post_link( $post_id, true ) . "'target='_blank' title='" . esc_attr( 'Edit this item' ) . "'>Admin View</a>";
				}
				elseif( $type == 'Users'){
					$this->detailed_log[$line_number]['VERIFY'] = "<b> Click here to verify</b> - <a href='" . get_edit_user_link( $post_id , true ) . "' target='_blank' title='" . esc_attr( 'Edit this item' ) . "'> User Profile </a>";
				}
				elseif($type == 'Comments'){					
					$this->detailed_log[$line_number]['VERIFY'] = "<b> Click here to verify</b> - <a href='" . get_comment_link( $post_id ) . "' target='_blank' title='" . esc_attr( sprintf( __( 'View &#8220;%s&#8221;' ), $post_values['post_title'] ) ) . "'rel='permalink'>Web View</a> | <a href='" . get_edit_comment_link( $post_id ) . "'target='_blank' title='" . esc_attr( 'Edit this item' ) . "'>Admin View</a>";
				}
				elseif($type == 'WooCommerce Orders' || $type == 'WooCommerce Coupons' || $type == 'lp_order'){
					$this->detailed_log[$line_number]['VERIFY'] = "<b> Click here to verify</b> - <a href='" . get_edit_post_link( $post_id, true ) . "'target='_blank' title='" . esc_attr( 'Edit this item' ) . "'>Admin View</a>";
				}				
				elseif($type == 'WooCommerce Product Variations' ){
					$post_values['post_title']=isset($post_values['post_title'])?$post_values['post_title']:'';
					$this->detailed_log[$line_number]['VERIFY'] = "<b> Click here to verify</b> - <a href='" . get_permalink( $post_id ) . "' target='_blank' title='" . esc_attr( sprintf( __( 'View &#8220;%s&#8221;' ), $post_values['post_title'] ) ) . "'rel='permalink'>Web View</a> ";
				}
				elseif($type == 'Tags' || $type == 'Categories' || $type == 'Taxonomies' || $type == 'post_tag' || $type =='Post_category'){
					$this->detailed_log[$line_number]['VERIFY'] = "<b> Click here to verify</b> - <a href='" . get_edit_term_link( $post_id, $import_type ) . "'target='_blank' title='" . esc_attr( 'Edit this item' ) . "'>Admin View</a>";
				}
				elseif($type == 'nav_menu_item'){
					$this->detailed_log[1]['Message'] = "Imported Successfully.";
				}
				else{			
					$post_value_title = isset($post_values['post_title']) ? $post_values['post_title'] : '';
					$this->detailed_log[$line_number]['VERIFY'] = "<b> Click here to verify</b> - <a href='" . get_permalink( $post_id ) . "' target='_blank' title='" . esc_attr( sprintf( __( 'View &#8220;%s&#8221;' ), $post_value_title ) ) . "'rel='permalink'>Web View</a> | <a href='" . get_edit_post_link( $post_id, true ) . "'target='_blank' title='" . esc_attr( 'Edit this item' ) . "'>Admin View</a>";					
				}
				if(isset($post_values['post_status'])){
					$this->detailed_log[$line_number]['  Status'] = $post_values['post_status'];
				}	
			}
			
			return $post_id;
		}
		global $wpdb;
		$optional_type = '';
		if(is_plugin_active('jet-engine/jet-engine.php')){
			$get_slug_name = $wpdb->get_results("SELECT slug FROM {$wpdb->prefix}jet_post_types WHERE status = 'content-type'");
			foreach($get_slug_name as $key=>$get_slug){
				$value=$get_slug->slug;
				$optionaltype=$value;						
				if($optionaltype == $type){
					$optional_type=$optionaltype;
				}
			}
		}	
	
		if($optional_type == $type){
			if($gmode != 'CLI'){
			$current_user = wp_get_current_user();									
			$author_id = $current_user->data->ID;
			}
			else { // else part is only used for set the author id
				$post_values = [];				
				$post_values = $this->import_core_fields($post_values,$mode, $line_number);
				$author_id = isset($post_values['post_author']) ? $post_values['post_author'] : "";				
				$author_id = $current_user->data->ID;
			}
			
			if($mode == 'Insert'){
				$post_values = [];
				$post_values = $helpers_instance->get_header_values($map , $header_array , $value_array);
				
				$post_values = $this->import_core_fields($post_values,$mode, $line_number);
				
				$table_name = 'jet_cct_'.$type;												
				$value_status =  empty($post_values['cct_status']) ? "publish" : $post_values['cct_status'] ;
				if($author_id)
					$wpdb->get_results("INSERT INTO {$wpdb->prefix}$table_name(cct_status,cct_author_id) values('$value_status',$author_id)");       			
				else 
					$wpdb->get_results("INSERT INTO {$wpdb->prefix}$table_name(cct_status) values('$value_status')");       			
				$get_result =  $wpdb->get_results("SELECT _ID FROM {$wpdb->prefix}$table_name WHERE  cct_status = '$value_status' order by _ID DESC ");			
				$id = $get_result[0];				
				$post_id = $id->_ID;
		
				$page = 'jet-cct-'.$type;
				$dir=site_url().'/wp-admin';				
				$wpdb->get_results("UPDATE $log_table_name SET created = $created_count WHERE $unikey_name = '$unikey_value'");
				$cct_post_title = isset($post_values['post_title']) ? $post_values['post_title'] : '';

				$this->detailed_log[$line_number]['Message'] = 'Inserted Custom Content Type '  . ' ID: ' . $post_id ;
				$this->detailed_log[$line_number]['VERIFY'] = "<b> Click here to verify</b> - <a href='$dir/admin.php?page=$page&cct_action=edit&item_id=$post_id' target='_blank' title='" . esc_attr( sprintf( __( 'View &#8220;%s&#8221;' ), $cct_post_title ) ) . "'rel='permalink'>Admin View</a>";	
				$this->detailed_log[$line_number][' Status'] = $value_status;
				if($unmatched_row == 'true'){
					global $wpdb;
					$type ='cct';
					$post_entries_table = $wpdb->prefix ."post_entries_table";
					$file_table_name = $wpdb->prefix."smackcsv_file_events";
					$get_id  = $wpdb->get_results( "SELECT file_name  FROM $file_table_name WHERE `hash_key` = '$hash_key'");	
					$file_name = $get_id[0]->file_name;
					$wpdb->get_results("INSERT INTO $post_entries_table (`ID`,`type`, `file_name`,`status`) VALUES ( '{$post_id}','{$type}', '{$file_name}','Inserted')");
				}			
				return $post_id;
			}
			else{
				if($check == '_ID'){
					$post_values = [];
					$post_values = $helpers_instance->get_header_values($map , $header_array , $value_array);					
					if(!empty($post_values['_ID'])){					
					$page = 'jet-cct-'.$type;
					$dir = site_url().'/wp-admin';
					$ID = $post_values['_ID'];	
					$table_name = 'jet_cct_'.$type;					
					$get_result =  $wpdb->get_results("SELECT _ID FROM {$wpdb->prefix}$table_name WHERE _ID = $ID AND cct_status != 'trash' order by _ID DESC ");								
					
					 if(!empty($get_result)) {
					if(isset($post_values['cct_status'])){
						$jet_status =  $post_values['cct_status'];
						$wpdb->update( $wpdb->prefix.'jet_cct_'.$type , 
							array( 
								'cct_status' => $jet_status,
							) , 
							array( '_ID' => $ID
							) 
						);
					}
					$updated_row_counts = $helpers_instance->update_count($unikey_value,$unikey_name);
					$updated_count = $updated_row_counts['updated'];
					$wpdb->get_results("UPDATE $log_table_name SET updated = $updated_count WHERE $unikey_name = '$unikey_value'");
					$status =  $wpdb->get_results("SELECT cct_status FROM {$wpdb->prefix}$table_name WHERE _ID = $ID ");
					$post_stat = $status[0]->cct_status;

					$cct_post_title = isset($post_values['post_title']) ? $post_values['post_title'] : '';

					$this->detailed_log[$line_number]['Message'] = 'Updated Custom Content Type '  . ' ID: ' . $ID ;
					$this->detailed_log[$line_number]['VERIFY'] = "<b> Click here to verify</b> - <a href='$dir/admin.php?page=$page&cct_action=edit&item_id=$ID' target='_blank' title='" . esc_attr( sprintf( __( 'View &#8220;%s&#8221;' ), $cct_post_title ) ) . "'rel='permalink'>Admin View</a>";	
					$this->detailed_log[$line_number][' Status'] = $post_stat;							
					if($unmatched_row == 'true'){
						global $wpdb;
						$type ='cct';
						$post_entries_table = $wpdb->prefix ."post_entries_table";
						$file_table_name = $wpdb->prefix."smackcsv_file_events";
						$get_id  = $wpdb->get_results( "SELECT file_name  FROM $file_table_name WHERE `hash_key` = '$hash_key'");	
						$file_name = $get_id[0]->file_name;
						$wpdb->get_results("INSERT INTO $post_entries_table (`ID`,`type`, `file_name`,`status`) VALUES ( '{$ID}','{$type}', '{$file_name}','Inserted')");
					}
					return $ID;	
				}
				else {
					$value_status =  empty($post_values['cct_status']) ? "publish" : $post_values['cct_status'] ;
				$wpdb->get_results("INSERT INTO {$wpdb->prefix}$table_name(cct_status,cct_author_id) values('$value_status',$author_id)");       			
				$get_result =  $wpdb->get_results("SELECT _ID FROM {$wpdb->prefix}$table_name WHERE  cct_status = '$value_status' order by _ID DESC ");										
				$post_id = $get_result[0]->_ID;
				$wpdb->get_results("UPDATE $log_table_name SET created = $created_count WHERE $unikey_name = '$unikey_value'");
				$cct_post_title = isset($post_values['post_title']) ? $post_values['post_title'] : '';

				$this->detailed_log[$line_number]['Message'] = 'Inserted Custom Content Type '  . ' ID: ' . $post_id ;
				$this->detailed_log[$line_number]['VERIFY'] = "<b> Click here to verify</b> - <a href='$dir/admin.php?page=$page&cct_action=edit&item_id=$post_id' target='_blank' title='" . esc_attr( sprintf( __( 'View &#8220;%s&#8221;' ), $cct_post_title ) ) . "'rel='permalink'>Admin View</a>";	
				$this->detailed_log[$line_number][' Status'] = $value_status;
				if($unmatched_row == 'true'){
					global $wpdb;
					$type ='cct';
					$post_entries_table = $wpdb->prefix ."post_entries_table";
					$file_table_name = $wpdb->prefix."smackcsv_file_events";
					$get_id  = $wpdb->get_results( "SELECT file_name  FROM $file_table_name WHERE `hash_key` = '$hash_key'");	
					$file_name = $get_id[0]->file_name;
					$wpdb->get_results("INSERT INTO $post_entries_table (`ID`,`type`, `file_name`,`status`) VALUES ( '{$post_id}','{$type}', '{$file_name}','Inserted')");
				}
				return $post_id;
				}
				}
				else {					
					$this->detailed_log[$line_number]['Message'] = "Skipped.Cannot update.ID's are empty."; 
					$wpdb->get_results("UPDATE $log_table_name SET skipped = $skipped_count WHERE $unikey_name = '$unikey_value'");
				}
				}
			}
		}
		
		elseif($type == 'Images' || $type == 'ngg_pictures'){
			$post_values = [];
			$file_table_name = $wpdb->prefix ."smackcsv_file_events";
			$get_id = $wpdb->get_results( "SELECT file_name FROM $file_table_name WHERE `hash_key` = '$hash_key'");
			
			$file_name = $get_id[0]->file_name;
			$file_extension = pathinfo($file_name, PATHINFO_EXTENSION);
			foreach($map as $key => $value){
				$csv_value= trim($map[$key]);
				if(!empty($csv_value)){
					$get_key= array_search($csv_value , $header_array);
					if(isset($value_array[$get_key])){
						if($file_extension == 'xml'){
							$csv_element = $value;
						}
						else{
						$csv_element = $value_array[$get_key];	
						}
						$wp_element= trim($key);
						if(!empty($csv_element) && !empty($wp_element)){
							$post_values[$wp_element] = $csv_element;
						}
					}
				}
			}

			if($type == 'Images'){
				//changed
				if(array_key_exists( 'image_url', $post_values)) {
					$keys = array_keys($post_values);
					$keys[array_search('image_url', $keys)] = 'featured_image';
					$post_values = array_combine($keys, $post_values);	
				}
			
				if(!empty($post_values['featured_image'])){
					$post_values['featured_image'] = $this->check_for_featured_image_url($post_values['featured_image']);
				}
				$result = CoreFieldsImport::$media_instance->image_import($post_values,$check,$mode,$line_number,$unikey_value ,$unikey_name);
			}
			if($type == 'ngg_pictures'){
				$result = CoreFieldsImport::$nextgen_instance->nextgenGallery($post_values,$check,$mode,$line_number,$header_array,$value_array);
			}
			return $result;
		}

		else{
			$post_values = [];
					
		    $current_user = wp_get_current_user();
		    $current_user_role = $current_user->roles[0];
		if($current_user_role == 'administrator'){
			$trim_content = array(
							'->static' => '', 
							'->math' => '', 
							'->cus1' => ''
						);
	
			foreach($map as $header_keys => $value){
				if( strpos($header_keys, '->cus2') !== false) {
					if(!empty($value)){
						$helpers_instance->write_to_customfile($value, $header_array, $value_array);
						unset($map[$header_keys]);
					}
				}
				else{
					$header_trim = strtr($header_keys, $trim_content);
					if($header_trim != $header_keys){
						unset($map[$header_keys]);
					}
					$map[$header_trim] = $value;
				}
			}
		}
			foreach($map as $key => $value){
			
				$csv_value = trim($map[$key]);
				$extension_object = new ExtensionHandler;
				$import_type = $extension_object->import_type_as($type);
				$import_as = $extension_object->import_post_types($import_type );

				if(!empty($csv_value)){
					//$pattern = "/({([a-z A-Z 0-9 | , _ -]+)(.*?)(}))/";
					$pattern1 = '/{([^}]*)}/';
					$pattern2 = '/\[([^\]]*)\]/';
					$file_table_name = $wpdb->prefix ."smackcsv_file_events";
			$get_id = $wpdb->get_results( "SELECT file_name FROM $file_table_name WHERE `hash_key` = '$hash_key'");
			
			$file_name = $get_id[0]->file_name;
			$file_extension = pathinfo($file_name, PATHINFO_EXTENSION);
					if(preg_match_all($pattern1, $csv_value, $matches, PREG_PATTERN_ORDER) && $file_extension !='xml'){		
						//check for inbuilt or custom function call -> enclosed in []
						if(preg_match_all($pattern2, $csv_value, $matches2)){
							$matched_element = $matches2[1][0];
							
							foreach($matches[1] as $value){
								$get_value = $helpers_instance->replace_header_with_values($value, $header_array, $value_array);
								$values = '{'.$value.'}';
								$get_value = "'".$get_value."'";
								$matched_element = str_replace($values, $get_value, $matched_element);
							}
						
							$csv_element = @eval("return " . $matched_element . ";" );
						}
						else{
							$csv_element = $csv_value;
							//foreach($matches[2] as $value){
							foreach($matches[1] as $value){
								$get_key = array_search($value , $header_array);
								if(isset($value_array[$get_key])){
									$csv_value_element = $value_array[$get_key];	
									
									$value = '{'.$value.'}';
									$csv_element = str_replace($value, $csv_value_element, $csv_element);	
								}
							}

							//check for math expression
							$math = 'MATH';
							if (strpos($csv_element, $math) !== false) {			
								$equation = str_replace('MATH', '', $csv_element);
								$csv_element = $helpers_instance->evalmath($equation);
							}
						}
						$wp_element= trim($key);
						if(!empty($csv_element) && !empty($wp_element)){
							$post_values[$wp_element] = $csv_element;	
							$post_values['post_type'] = $import_as;
						//	$post_values = $this->import_core_fields($post_values,$mode, $line_number);
						}
					}
					// for custom function without headers in it
					elseif(preg_match_all($pattern2, $csv_value, $matches2) && $file_extension !='xml'){
						$matched_element = $matches2[1][0];
					
						$wp_element= trim($key);
						$csv_element1 = @eval("return " . $matched_element . ";" );
						$post_values[$wp_element] = $csv_element1;
					}

					elseif(!in_array($csv_value , $header_array)){
						$wp_element= trim($key);
						$post_values[$wp_element] = $csv_value;
						$post_values['post_type'] = $import_as;
						//$post_values = $this->import_core_fields($post_values,$mode, $line_number);
					}
				    
					else{
						$get_key = array_search($csv_value , $header_array);
						if(isset($value_array[$get_key])){
							$csv_element = $value_array[$get_key];
							$wp_element= trim($key);
							$extension_object = new ExtensionHandler;
							$import_type = $extension_object->import_type_as($type);
							$import_as = $extension_object->import_post_types($import_type );
							if($mode == 'Insert'){
								if(!empty($csv_element) && !empty($wp_element)){
									$post_values[$wp_element] = $csv_element;
									$post_values['post_type'] = $import_as;
									//$post_values = $this->import_core_fields($post_values,$mode, $line_number);
								}
							}
							else{
								if(!empty($csv_element) || !empty($wp_element)){
									$post_values[$wp_element] = $csv_element;
									$post_values['post_type'] = $import_as;
									//$post_values = $this->import_core_fields($post_values,$mode, $line_number);
								}
							}
							if($import_as == 'page'){
								if(isset($post_values['post_parent'])){
									if(!is_numeric($post_values['post_parent'])){
											$post_parent_title = $post_values['post_parent'];
											$post_parent_id = $wpdb->get_var("SELECT ID FROM {$wpdb->prefix}posts WHERE post_title = '$post_parent_title' AND post_type = 'page'");
											$post_values['post_parent'] = $post_parent_id;
									}
								}
							}
						}
					}
				}
			}
			$post_values = $this->import_core_fields($post_values,$mode, $line_number);
			if($check == 'ID'){	
				$ID = $post_values['ID'];	
				$get_result =  $wpdb->get_results("SELECT ID FROM {$wpdb->prefix}posts WHERE ID = $ID AND post_type = '$import_as' AND post_status != 'trash' order by ID DESC ");			
			}
			if($check == '_ID'){
				$ID = $post_values['_ID'];	
				// $table_name.='wp_jet_cct_'.$type;
				// $get_result =  $wpdb->get_results("SELECT _ID FROM $table_name WHERE _ID = $ID AND cct_status != 'trash' order by _ID DESC ");			
				// foreach($get_result as $key=>$get_slug){
				// 	$post_id=$get_slug->_ID;
				// }
				//return $post_id;		
				return $ID;
			}
			if($check == 'post_title'){
				$title = $post_values['post_title'];
				$title = $wpdb->_real_escape($title);
				if($sitepress !=null){
					$get_result =  $wpdb->get_results("SELECT ID FROM {$wpdb->prefix}posts WHERE post_title = '$title' AND post_type = '$import_as' AND post_status != 'trash' order by ID DESC ");		
					if(!empty($get_result)){
					foreach($get_result as $wpml_result){
						$wpml_id[] = $wpml_result->ID;
					}	
					$template_table_name = $wpdb->prefix . "ultimate_csv_importer_mappingtemplate";
					$background_values = $wpdb->get_results("SELECT mapping FROM $template_table_name WHERE `eventKey` = '$hash_key' ");
					foreach ($background_values as $values) {
						$mapped_fields_values = $values->mapping;
					}
					$map_wpml = unserialize($mapped_fields_values);
					
					$wpml_values = $helpers_instance->get_header_values($map_wpml['WPML'], $header_array , $value_array);
					$get_results =array();
					$w = 0;
					foreach($wpml_id as $w_id){
						$languagecode =  $wpdb->get_var("SELECT language_code FROM {$wpdb->prefix}icl_translations WHERE element_id = '$w_id'");		
						if($wpml_values['language_code'] == $languagecode){
							$get_results[$w]['ID']= $w_id;

							$w++;
						}
					}
					if(!empty($get_results) && is_array($get_results)){
						foreach($get_results as $g_result){
							$getresult[] = (object) $g_result;
						}
					}
					else{
						$get_result = array();
					}
					
				}
				}
				else{
					$get_result =  $wpdb->get_results("SELECT ID FROM {$wpdb->prefix}posts WHERE post_title = '$title' AND post_type = '$import_as' AND post_status != 'trash' order by ID DESC ");		
				}
				
			}
			if($check == 'post_name'){
				$name = $post_values['post_name'];
				$get_result =  $wpdb->get_results("SELECT ID FROM {$wpdb->prefix}posts WHERE post_name = '$name' AND post_type = '$import_as' AND post_status != 'trash' order by ID DESC ");	
			}
			if($check == 'post_content'){
				$content = $post_values['post_content'];
				$get_result =  $wpdb->get_results("SELECT ID FROM {$wpdb->prefix}posts WHERE post_content = '$content' AND post_type = '$import_as' AND post_status != 'trash' order by ID DESC ");	
			}
			$update = array('ID','post_title','post_name','post_content');
	
			if(!in_array($check, $update)){
				if($update_based_on == 'acf'){
					if(is_plugin_active('advanced-custom-fields-pro/acf.php')||is_plugin_active('advanced-custom-fields/acf.php')){
						$get_result = $this->custom_fields_update_based_on($update_based_on, $acf, $check, $header_array, $value_array);
					}
				}
				elseif($update_based_on == 'toolset'){
					if(is_plugin_active('types/wpcf.php')){
						$get_result = $this->custom_fields_update_based_on($update_based_on, $toolset, $check, $header_array, $value_array);
					}
				}
				if($update_based_on == 'pods'){
					if(is_plugin_active('pods/init.php')){
						$get_result = $this->custom_fields_update_based_on($update_based_on, $pods, $check, $header_array, $value_array);
					}
				}	
			}					

			if($mode == 'Insert'){
		
				if (isset($get_result) && is_array($get_result) && !empty($get_result)) {
					$wpdb->get_results("UPDATE $log_table_name SET skipped = $skipped_count WHERE $unikey_name = '$unikey_value'");
					$this->detailed_log[$line_number]['Message'] =  "Skipped, Due to duplicate found!.";
				}
				elseif(!empty($this->detailed_log) && isset($this->detailed_log[$line_number]) && preg_match("(Skipped)", $this->detailed_log[$line_number]['Message']) != 0) {
					$wpdb->get_results("UPDATE $log_table_name SET skipped = $skipped_count WHERE $unikey_name
					 = '$unikey_value'");
				}
				else{
					
								
					//set the post parent
					if( (isset($post_values['post_parent'])) && (!is_numeric($post_values['post_parent'])) && (!empty($post_values['post_parent']))){
						$p_type=$post_values['post_type'];
						$parent_title=$post_values['post_parent'];
						$parent_id = $wpdb->get_var( "SELECT ID FROM $wpdb->posts WHERE post_title = '$parent_title' and post_status !='trash' and post_type='$p_type'" );
						$post_values['post_parent']=$parent_id;
					}

					//Insert the posts
					if($post_values['post_status']!='delete'){
						if(isset($post_values['ID'])){
							unset($post_values['ID']);
						}
						
						if(is_plugin_active('multilanguage/multilanguage.php')) {
							$post_id = $this->multiLang($post_values);
						}
						else if($sitepress !=null){
							$post_values['post_content']=isset($post_values['post_content'])?$post_values['post_content']:'';
							$post_values['post_content'] = html_entity_decode($post_values['post_content']);
							$active_languages = $wpdb->get_results("SELECT code FROM {$wpdb->prefix}icl_languages where active = 1");
							foreach($active_languages as $lang){
								$active [] =$lang->code;
							}
							$template_table_name = $wpdb->prefix . "ultimate_csv_importer_mappingtemplate";
							$background_values = $wpdb->get_results("SELECT mapping FROM $template_table_name WHERE `eventKey` = '$hash_key' ");
							foreach ($background_values as $values) {
								$mapped_fields_values = $values->mapping;
							}
							$map_wpml = unserialize($mapped_fields_values);
							
							$wpml_values = $helpers_instance->get_header_values($map_wpml['WPML'], $header_array , $value_array);
							if(!empty($wpml_values['language_code'])){
								if(in_array($wpml_values['language_code'],$active)){
									$post_id = wp_insert_post($post_values);
									$status = $post_values['post_status'];
									$update=$wpdb->get_results("UPDATE {$wpdb->prefix}posts set post_status = '$status' where id = $post_id");
								}
								else{
									$wpml_message = "The given language code not configured in WPML";
								}
							}
							else{
								
								$post_values['post_content']=isset($post_values['post_content'])?$post_values['post_content']:'';
								$post_values['post_content'] = html_entity_decode($post_values['post_content']);																				
								
								$post_id = wp_insert_post($post_values);							
								$status = $post_values['post_status'];
								$update=$wpdb->get_results("UPDATE {$wpdb->prefix}posts set post_status = '$status' where id = $post_id");
								
							}
						}
						else{
							$post_values['post_content']=isset($post_values['post_content'])?$post_values['post_content']:'';
							$post_values['post_content'] = html_entity_decode($post_values['post_content']);																				
							
							$post_id = wp_insert_post($post_values);							
							$status = $post_values['post_status'];
							$update=$wpdb->get_results("UPDATE {$wpdb->prefix}posts set post_status = '$status' where id = $post_id");
						}
						if(!empty($post_values['wp_page_template'])){
							update_post_meta($post_id, '_wp_page_template', $post_values['wp_page_template']);
						}
					}

					if($post_values['post_status'] == 'delete'){
						$post_title = $post_values['post_title'];
						$post_id = $wpdb->get_results("select ID from {$wpdb->prefix}posts where post_title = '$post_title'");
						foreach($post_id as $value){
							$posts = $value->ID;
							wp_delete_post($posts,true); 
						}
					}

					$post_values['specific_author'] = isset($post_values['specific_author']) ? $post_values['specific_author'] : "";
		
					if($unmatched_row == 'true'){
						global $wpdb;
						$post_entries_table = $wpdb->prefix ."post_entries_table";
						$file_table_name = $wpdb->prefix."smackcsv_file_events";
						$get_id  = $wpdb->get_results( "SELECT file_name  FROM $file_table_name WHERE `$unikey_name` = '$unikey_value'");	
						$file_name = $get_id[0]->file_name;
						$wpdb->get_results("INSERT INTO $post_entries_table (`ID`,`type`, `file_name`,`status`) VALUES ( '{$post_id}','{$type}', '{$file_name}','Inserted')");
					}

					if(isset($post_values['post_format'])){
						$this->post_format_function($post_id, $post_values['post_format']);
					}

					if(is_plugin_active('post-expirator/post-expirator.php')) {
						$this->postExpirator($post_id,$post_values);
					}

					$media_handle = get_option('smack_image_options');
					if($media_handle['media_settings']['media_handle_option'] == 'true' && $media_handle['media_settings']['enable_postcontent_image'] == 'true'){
					
						if(preg_match("/<img/", $post_values['post_content'])) {

							$content = "<p>".$post_values['post_content']."</p>";
							$doc = new \DOMDocument();
							if(function_exists('mb_convert_encoding')) {
								@$doc->loadHTML( mb_convert_encoding( $content, 'HTML-ENTITIES', 'UTF-8' ), LIBXML_HTML_NOIMPLIED | LIBXML_HTML_NODEFDTD );
							}else{
								@$doc->loadHTML( $content);
							}
							$searchNode = $doc->getElementsByTagName( "img" );
							if ( ! empty( $searchNode ) ) {
								foreach ( $searchNode as $searchNode ) {
									$orig_img_src []= $searchNode->getAttribute( 'src' ); 			
									$media_dir = wp_get_upload_dir();
									$names = $media_dir['url'];
									$image_type = 'inline';	
									foreach($orig_img_src as $orig_src){								
									if (strpos($orig_src , $names) !== false) {
										$shortcode_img = $orig_src;
										$check_inline_image = $wpdb->get_results("SELECT $unikey_name FROM {$wpdb->prefix}ultimate_csv_importer_media_report WHERE $unikey_name = '$unikey_value'  AND image_type = 'inline' "); 
										if(empty($check_inline_image)){
											$image_table = $wpdb->prefix . "ultimate_csv_importer_media_report";
											$wpdb->get_results("INSERT INTO $image_table (`hash_key`,`templatekey`,`module`,`image_type`,`status`) VALUES ( '{$hash_key}','{$templatekey}','{$type}','{$image_type}','Completed')");
										}										
									}
									else{
										$rand = mt_rand(1, 999);	
										$shortcode_table = $wpdb->prefix . "ultimate_csv_importer_shortcode_manager";
										$get_shortcode = $wpdb->get_results("SELECT `image_shortcode` FROM $shortcode_table WHERE original_image = '{$orig_src}' ",ARRAY_A);
										$image_table = $wpdb->prefix . "ultimate_csv_importer_media_report";
										$get_success_count = $wpdb->get_var("SELECT success_count FROM $image_table WHERE $unikey_name = '$unikey_value'  AND image_type = '$image_type' "); 
										//Record not exists 
										if(!$get_success_count)
										$wpdb->get_results("INSERT INTO $image_table (`hash_key`,`templatekey`,`module`,`image_type`,`status`) VALUES ( '{$hash_key}','{$templatekey}','{$type}','{$image_type}','Completed')");
										if(!empty($get_shortcode)) 
										{
											$shortcode_img = $get_shortcode[0]['image_shortcode'];
										}		
										else{
											$shortcode_img = 'inline_'.$rand.'_'.$orig_src;
										}
									}
								}

									$temp_img = plugins_url("../assets/images/loading-image.jpg", __FILE__);
									$searchNode->setAttribute( 'src', $temp_img);
									$searchNode->setAttribute( 'alt', $shortcode_img );

								}
								$post_content              = $doc->saveHTML();
								$post_values['post_content'] = $post_content;
								$update_content['ID']           = $post_id;
								$update_content['post_content'] = $post_content;
								wp_update_post( $update_content );
							}
						}
					}		
					
					$wpdb->get_results("UPDATE $log_table_name SET created = $created_count WHERE $unikey_name = '$unikey_value'");
						
					if(preg_match("/<img/", $post_values['post_content'])) {
						$shortcode_table = $wpdb->prefix . "ultimate_csv_importer_shortcode_manager";
						$doc = new \DOMDocument();
							$searchNode = $doc->getElementsByTagName( "img" );
							if ( ! empty( $searchNode ) ) {
								foreach ( $searchNode as $searchNode ) {
									$orig_img_src = $searchNode->getAttribute( 'src' ); 
								}
							}			
							$media_dir = wp_get_upload_dir();
							$names = $media_dir['url'];
						if(isset($orig_img_src)){
							foreach ($orig_img_src as $img => $img_val){
								$shortcode  = 'inline';
								$wpdb->get_results("INSERT INTO $shortcode_table (image_shortcode , original_image , post_id,hash_key,templatekey) VALUES ( '{$shortcode}', '{$img_val}', $post_id  ,'{$hash_key}','{$templatekey}')");																				
							}
						}
					}			
					$media_dir = wp_get_upload_dir();
					$names = $media_dir['url'];
						
					// image handling code
					
					if($media_handle['media_settings']['media_handle_option'] == 'true' && !empty($post_values['featured_image'])  && !is_plugin_active('featured-image-from-url/featured-image-from-url.php')){
						update_option('ultimate_csv_importer_pro_featured_image', $post_values['featured_image']);
						$post_values['featured_image'] = $this->check_for_featured_image_url($post_values['featured_image']);
						$attach_id = $this->featured_image_handling($media_handle, $post_values, $post_id, $type, $get_import_type, $unikey_value, $unikey_name, $header_array, $value_array,$hash_key,$templatekey);
					}

					if(is_wp_error($post_id) || $post_id == '') {
						if(is_wp_error($post_id)) {
							$this->detailed_log[$line_number]['Message'] = "Can't insert this " . $post_values['post_type'] . ". " . $post_id->get_error_message();
						}
						else {
							$wpml_message  = isset($wpml_message )?$wpml_message:'';
							if($sitepress !=null){
								$this->detailed_log[$line_number]['Message'] =  "Can't insert this " . $post_values['post_type'].'. '.$wpml_message;
							}
							else{
								$this->detailed_log[$line_number]['Message'] =  "Can't insert this " . $post_values['post_type'];
							}
						}
						$wpdb->get_results("UPDATE $log_table_name SET skipped = $skipped_count WHERE $unikey_name = '$unikey_value'");
					}	
					else{
						$this->detailed_log[$line_number]['Message'] = 'Inserted ' . $post_values['post_type'] . ' ID: ' . $post_id . ', ' . $post_values['specific_author'];
					}
				}
			}
			
            if($mode == 'Update'){						
				if(isset($this->detailed_log[$line_number]['Message']) && preg_match("(Skipped)", $this->detailed_log[$line_number]['Message']) !== 0) {					
					$wpdb->get_results("UPDATE $log_table_name SET skipped = $skipped_count WHERE $unikey_name = '$unikey_value'");
				}				
				else {									
				if (is_array($get_result) && !empty($get_result)) {	
					if(!in_array($check, $update)){
						$post_id = $get_result[0]->post_id;	
						$post_values['ID'] = $post_id;
					}else{
						$post_id = $get_result[0]->ID;		
						$post_values['ID'] = $post_id;							
					}										
					$media_handle = get_option('smack_image_options');
					if($media_handle['media_settings']['media_handle_option'] == 'true' && !empty($post_values['featured_image'])){
						update_option('ultimate_csv_importer_pro_featured_image', $post_values['featured_image']);
					}
					// image handling code
					if($media_handle['media_settings']['media_handle_option'] == 'true' && !empty($post_values['featured_image'])){
						$post_values['featured_image'] = $this->check_for_featured_image_url($post_values['featured_image']);
						$attach_id = $this->featured_image_handling($media_handle, $post_values, $post_id, $type, $get_import_type, $unikey_value, $unikey_name, $header_array, $value_array,$hash_key,$templatekey);
					}
					if(isset($post_values['post_content']) && $media_handle['media_settings']['media_handle_option'] == 'true' 
					&& isset($media_handle['media_settings']['enable_postcontent_image'])
					&& $media_handle['media_settings']['enable_postcontent_image'] == 'true'){
						if(preg_match("/<img/", $post_values['post_content'])) {

							$content = "<p>".$post_values['post_content']."</p>";
							$doc = new \DOMDocument();
							if(function_exists('mb_convert_encoding')) {
								@$doc->loadHTML( mb_convert_encoding( $content, 'HTML-ENTITIES', 'UTF-8' ), LIBXML_HTML_NOIMPLIED | LIBXML_HTML_NODEFDTD );
							}else{
								@$doc->loadHTML( $content);
							}
							$searchNode = $doc->getElementsByTagName( "img" );
							if ( ! empty( $searchNode ) ) {
								foreach ( $searchNode as $searchNode ) {
									$orig_img_src[] = $searchNode->getAttribute( 'src' ); 			
									$media_dir = wp_get_upload_dir();
									$names = $media_dir['url'];

									$shortcode_img[] = $orig_img_src;

									$temp_img = plugins_url("../assets/images/loading-image.jpg", __FILE__);
									$searchNode->setAttribute( 'src', $temp_img);									
									$orig_img_alt = $searchNode->getAttribute( 'alt' );
									if(!empty($orig_img_alt)){
										$media_handle['postcontent_image_alt'] = $orig_img_alt;
										update_option('smack_image_options', $media_handle);
									}

								}
								$post_content              = $doc->saveHTML();
								$post_values['post_content'] = $post_content;
								$update_content['ID']           = $post_id;
								$update_content['post_content'] = $post_content;
								wp_update_post( $update_content );
							}
						}
					}

					if(!empty($post_values['post_content']) && preg_match("/<img/", $post_values['post_content'])) {
				
						$shortcode_table = $wpdb->prefix . "ultimate_csv_importer_shortcode_manager";
						if(! empty($orig_img_src)){
						 foreach ($orig_img_src as $img => $img_val){						 	
							 $shortcode  = 'inline';
							 $wpdb->get_results("INSERT INTO $shortcode_table (image_shortcode , original_image , post_id,hash_key,templatekey) VALUES ( '{$shortcode}', '{$img_val}', $post_id  ,'{$hash_key}','{$templatekey}')");
						 }
						}
				
						$doc = new \DOMDocument();
						$searchNode = $doc->getElementsByTagName( "img" );
						
						if ( ! empty( $searchNode ) ) {
							foreach ( $searchNode as $searchNode ) {
								$orig_img_src = $searchNode->getAttribute( 'src' ); 
							}
						}			
						
						$media_dir = wp_get_upload_dir();
						$names = $media_dir['url'];
					}

					if(empty($post_values['post_status'])){
						global $wpdb;
						$post_id = $get_result[0]->ID;
						$Post_status_value = $wpdb->get_results("SELECT post_status FROM {$wpdb->prefix}posts WHERE id = '$post_id'");
						$post_values['post_status'] = $Post_status_value[0]->post_status;
					}
					if($post_values['post_status']== 'delete'){
						wp_delete_post($post_values['ID'],true);
					}else{									
						if(isset($post_values['post_content'])){
							$post_values['post_content'] = html_entity_decode($post_values['post_content']);																
						}
						wp_update_post($post_values);
					}
					
					if(isset($post_values['post_format'])){
						$this->post_format_function($post_id, $post_values['post_format']);
					}
					$status = $post_values['post_status'];
					$wpdb->get_results("UPDATE {$wpdb->prefix}posts set post_status = '$status' where id = $post_id");
					$wpdb->get_results("UPDATE $log_table_name SET updated = $updated_count WHERE $unikey_name = '$unikey_value'");
					// if(isset($post_values['specific_author'])) {
					$this->detailed_log[$line_number]['Message'] = 'Updated' . $post_values['post_type'] . ' ID: ' . $post_id . ', ' . $post_values['specific_author'];
					// }
				}else{
					//while Update(inserting[records not exists already ])
					if($check == 'post_title'){
						unset($post_values['ID']);
					}
					$media_handle = get_option('smack_image_options');
					if($media_handle['media_settings']['media_handle_option'] == 'true' && !empty($post_values['featured_image'])){
						update_option('ultimate_csv_importer_pro_featured_image', $post_values['featured_image']);
					}
					// image handling code
					if($media_handle['media_settings']['media_handle_option'] == 'true' && !empty($post_values['featured_image'])){
						$post_values['featured_image'] = $this->check_for_featured_image_url($post_values['featured_image']);
						$attach_id = $this->featured_image_handling($media_handle, $post_values, $post_id, $type, $get_import_type, $unikey_value, $unikey_name, $header_array, $value_array,$hash_key,$templatekey);
					}					
				
					if($media_handle['media_settings']['media_handle_option'] == 'true' && $media_handle['media_settings']['enable_postcontent_image'] == 'true'){
					
						if(preg_match("/<img/", $post_values['post_content'])) {

							$content = "<p>".$post_values['post_content']."</p>";
							$doc = new \DOMDocument();
							if(function_exists('mb_convert_encoding')) {
								@$doc->loadHTML( mb_convert_encoding( $content, 'HTML-ENTITIES', 'UTF-8' ), LIBXML_HTML_NOIMPLIED | LIBXML_HTML_NODEFDTD );
							}else{
								@$doc->loadHTML( $content);
							}
							$searchNode = $doc->getElementsByTagName( "img" );
							if ( ! empty( $searchNode ) ) {
								foreach ( $searchNode as $searchNode ) {
									$orig_img_src = $searchNode->getAttribute( 'src' );
									$media_dir = wp_get_upload_dir();
									$names = $media_dir['url'];
									$image_type = 'inline';
									if (strpos($orig_img_src , $names) !== false) {
										$shortcode_img = $orig_img_src;
										$check_inline_image = $wpdb->get_results("SELECT $unikey_name FROM {$wpdb->prefix}ultimate_csv_importer_media_report WHERE $unikey_name = '$unikey_value'  AND image_type = 'inline' "); 										
											$image_table = $wpdb->prefix . "ultimate_csv_importer_media_report";
											$wpdb->get_results("INSERT INTO $image_table (`hash_key`,`templatekey`,`module`,`image_type`,`status`) VALUES ( '{$hash_key}','{$templatekey}','{$type}','{$image_type}','Completed')");										
									}
									else{
										$rand = mt_rand(1, 999);	
										$shortcode_table = $wpdb->prefix . "ultimate_csv_importer_shortcode_manager";
										$get_shortcode = $wpdb->get_results("SELECT `image_shortcode` FROM $shortcode_table WHERE original_image = '{$orig_img_src}' ",ARRAY_A);
										$image_table = $wpdb->prefix . "ultimate_csv_importer_media_report";
										$get_success_count = $wpdb->get_var("SELECT success_count FROM $image_table WHERE $unikey_name = '$unikey_value'  AND image_type = '$image_type' "); 
										//Record not exists 
										if(!$get_success_count)
										$wpdb->get_results("INSERT INTO $image_table (`hash_key`,`templatekey`,`module`,`image_type`,`status`) VALUES ( '{$hash_key}','{$templatekey}','{$type}','{$image_type}','Completed')");
										if(!empty($get_shortcode)) 
										{
											$shortcode_img = $get_shortcode[0]['image_shortcode'];
										}		
										else{
											$shortcode_img = 'inline_'.$rand.'_'.$orig_img_src;
										}
									}

									$temp_img = plugins_url("../assets/images/loading-image.jpg", __FILE__);
									$searchNode->setAttribute( 'src', $temp_img);
									$searchNode->setAttribute( 'alt', $shortcode_img );

								}
								$post_content              = $doc->saveHTML();
								$post_values['post_content'] = $post_content;
								$update_content['ID']           = $post_id;
								$update_content['post_content'] = $post_content;
								wp_update_post( $update_content );
							}
						}
					}
					$post_id = wp_insert_post($post_values);
					if(!empty($post_values['wp_page_template']) && $type == 'Pages'){
						update_post_meta($post_id, '_wp_page_template', $post_values['wp_page_template']);
					}
					if(isset($post_values['post_format'])){
						if($post_values['post_format'] == 'post-format-video' ){
							$format = 'video';
						}
						else{
							$format=trim($post_values['post_format'],"post-format-");
						}
						set_post_format($post_id , $format);
					}
					$wpdb->get_results("UPDATE $log_table_name SET created = $created_count WHERE $unikey_name = '$unikey_value'");
					if(isset($post_values['post_content'])) {
					if(preg_match("/<img/", $post_values['post_content'])) {
						$shortcode_table = $wpdb->prefix . "ultimate_csv_importer_shortcode_manager";
						$doc = new \DOMDocument();
							$searchNode = $doc->getElementsByTagName( "img" );
							if ( ! empty( $searchNode ) ) {
								foreach ( $searchNode as $searchNode ) {
									$orig_img_src = $searchNode->getAttribute( 'src' ); 
								}
							}			
							$media_dir = wp_get_upload_dir();
							$names = $media_dir['url'];
						if(isset($orig_img_src)){							
								$shortcode  = 'inline';
								$wpdb->get_results("INSERT INTO $shortcode_table (image_shortcode , original_image , post_id,hash_key,templatekey) VALUES ( '{$shortcode}', '{$orig_img_src}', $post_id  ,'{$hash_key}','{$templatekey}')");														
						}						
					}
				}
					if(is_wp_error($post_id) || $post_id == '') {
						if(is_wp_error($post_id)) {
							$this->detailed_log[$line_number]['Message'] = "Can't insert this " . $post_values['post_type'] . ". " . $post_id->get_error_message();
						}
						else {
							$this->detailed_log[$line_number]['Message'] =  "Can't insert this " . $post_values['post_type'];
						}
						$wpdb->get_results("UPDATE $log_table_name SET skipped = $skipped_count WHERE $unikey_name = '$unikey_value'");
					}
					else{
						// if(isset($post_values['specific_author'])) {
						$this->detailed_log[$line_number]['Message'] = 'Inserted ' . $post_values['post_type'] . ' ID: ' . $post_id . ', ' . $post_values['specific_author'];	
						// }
					}

					if($post_values['post_type'] == 'event' || $post_values['post_type'] == 'event-recurring'){
						$status = $post_values['post_status'];
						$wpdb->get_results("UPDATE {$wpdb->prefix}posts set post_status = '$status' where id = $post_id");
					}
				}

				if($unmatched_row == 'true'){
					global $wpdb;
					$post_entries_table = $wpdb->prefix ."post_entries_table";
					$file_table_name = $wpdb->prefix."smackcsv_file_events";
					$get_id  = $wpdb->get_results( "SELECT file_name  FROM $file_table_name WHERE `$unikey_name` = '$unikey_value'");	
					$file_name = $get_id[0]->file_name;
					$wpdb->get_results("INSERT INTO $post_entries_table (`ID`,`type`, `file_name`,`status`) VALUES ( '{$post_id}','{$type}', '{$file_name}','Updated')");
				}
			}
		}

			//update finished
	
			if (isset($this->detailed_log[$line_number]) && isset($this->detailed_log[$line_number]['Message']) && preg_match("(Can't|Skipped|Duplicate)", $this->detailed_log[$line_number]['Message']) === 0) {
				if ( $type == 'Posts' || $type == 'CustomPosts' || $type == 'Pages' || $type == 'Tickets') {
					
					if ( ! isset( $post_values['post_title'] ) ) {
						$post_values['post_title'] = '';
					}
					if ($gmode == 'Normal'){
						$this->detailed_log[$line_number]['VERIFY'] = "<b> Click here to verify</b> - <a href='" . get_permalink( $post_id ) . "' target='_blank' title='" . esc_attr( sprintf( __( 'View &#8220;%s&#8221;' ), $post_values['post_title'] ) ) . "'rel='permalink'>Web View</a> | <a href='" . get_edit_post_link( $post_id, true ) . "'target='_blank' title='" . esc_attr( 'Edit this item' ) . "'>Admin View</a>";	
					}
					else{
						if(empty($post_id)){
							$this->detailed_log[$line_number][' Message'] = 'Skipped';
						}
						else{
							$get_guid =$wpdb->get_results("select guid from {$wpdb->prefix}posts where ID= '$post_id'" ,ARRAY_A);
							$link = $get_guid[0]['guid'];

							$get_edit_link = get_edit_post_link( $post_id, true );
							if(empty($get_edit_link)){
								$get_edit_link = site_url().'/wp-admin/post.php?&post='.$post_id.'&action=edit';
							}													
							$this->detailed_log[$line_number]['VERIFY'] = "<b> Click here to verify</b> - <a href='" . $link . "' target='_blank' title='" . esc_attr( sprintf( __( 'View &#8220;%s&#8221;' ), $post_values['post_title'] ) ) . "'rel='permalink'>Web View</a> | <a href='" .$get_edit_link. "'target='_blank' title='" . esc_attr( 'Edit this item' ) . "'>Admin View</a>";	
						}
					}
			    }
				else{
					$this->detailed_log[$line_number]['VERIFY'] = "<b> Click here to verify</b> - <a href='" . get_permalink( $post_id ) . "' target='_blank' title='" . esc_attr( sprintf( __( 'View &#8220;%s&#8221;' ), $post_values['post_title'] ) ) . "'rel='permalink'>Web View</a> | <a href='" . get_edit_post_link( $post_id, true ) . "'target='_blank' title='" . esc_attr( 'Edit this item' ) . "'>Admin View</a>";
				}
				$this->detailed_log[$line_number][' Status'] = $post_values['post_status'];
			}						
			return $post_id;
		}
	}

	public function multiLang($post_values){
		global $wpdb;
		if (strpos($post_values['post_title'], '|') !== false) {
			$exploded_title = explode('|', $post_values['post_title']);
			$post_values['post_title'] = $exploded_title[0];
			$lang_title = $exploded_title[1];

		}
		if (strpos($post_values['post_content'], '|') !== false) {
			$exploded_content = explode('|', $post_values['post_content']);
			$post_values['post_content'] = $exploded_content[0];
			$lang_content = $exploded_content[1];
		}
		if (strpos($post_values['post_excerpt'], '|') !== false) {
			$exploded_excerpt = explode('|', $post_values['post_excerpt']);
			$post_values['post_excerpt'] = $exploded_excerpt[0];
			$lang_excerpt = $exploded_excerpt[1];
		}
		$lang_code = $post_values['lang_code'];
		$post_id = wp_insert_post($post_values);
		$wpdb->get_results("INSERT INTO {$wpdb->prefix}mltlngg_translate (post_ID , post_content , post_excerpt, post_title,`language`) VALUES ( $post_id, '{$lang_content}', '{$lang_excerpt}' , '{$lang_title}', '{$lang_code}')");
		return $post_id;
	}

	public function postExpirator($post_id,$post_values){
		if(!empty($post_values['post_expirator_status'])){
			$post_values['post_expirator_status'] = array('expireType' => $post_values['post_expirator_status'],'id' => $post_id);
		}
		else{
			$post_values['post_expirator_status'] = array('expireType' => 'draft' ,'id' => $post_id);
		}

		if(!empty($post_values['post_expirator'])){
			update_post_meta($post_id, '_expiration-date-status', 'saved');
			$estimate_date = $post_values['post_expirator'];
			$estimator_date = get_gmt_from_date("$estimate_date",'U');
			update_post_meta($post_id, '_expiration-date', $estimator_date);
			update_post_meta($post_id, '_expiration-date-options', $post_values['post_expirator_status']);			
		}	
	}


	function image_handling($id){

		global $wpdb;	
		$post_values = [];
		$get_result =  $wpdb->get_results("SELECT post_content FROM {$wpdb->prefix}posts where ID = $id ",ARRAY_A);   
		if(empty($get_result)){
			$get_result[0]['post_content'] = '';
			$post_values['post_content']=htmlspecialchars_decode($get_result[0]['post_content']);
		}
		else{
			$post_values['post_content']=htmlspecialchars_decode($get_result[0]['post_content']);
		}
		$get_result =  $wpdb->get_results("SELECT original_image FROM {$wpdb->prefix}ultimate_csv_importer_shortcode_manager where post_id = $id and image_shortcode ='inline'",ARRAY_A);   	
		foreach($get_result as $result){
			$orig_img_src[] = $result['original_image'];
		}
		$get_results =  $wpdb->get_results("SELECT image_shortcode FROM {$wpdb->prefix}ultimate_csv_importer_shortcode_manager where post_id = $id",ARRAY_A);   
		foreach ($get_results as $results){
			$origs_img_src[] = $results['image_shortcode'];
		}

		$image_type = 'Inline' ;
		if(!empty($orig_img_src)){
			foreach($orig_img_src as $src){
				$attach_id[] = CoreFieldsImport::$media_instance->media_handling( $src , $id ,$post_values,'',$image_type,'');
			}
		}
		if(!empty($attach_id)){			
			foreach($attach_id as $att_key => $att_val){
				if(!empty($att_val))
				$get_guid[] = $wpdb->get_results("SELECT guid FROM {$wpdb->prefix}posts WHERE post_type = 'attachment' and ID =  $att_val ",ARRAY_A);				
				foreach($origs_img_src as $img_src){					
					$result  = str_replace($img_src , ' ' , $post_values['post_content']);
				}
			}
		}
		$image_name = isset($result) ? $result :'';
		$doc = new \DOMDocument();
		if(!empty($image_name)){
			if(function_exists('mb_convert_encoding')) {
				@$doc->loadHTML( mb_convert_encoding( $image_name, 'HTML-ENTITIES', 'UTF-8' ), LIBXML_HTML_NOIMPLIED | LIBXML_HTML_NODEFDTD );
			}else{
				@$doc->loadHTML( $image_name);
			}
		}
		$img_tags = $doc->getElementsByTagName('img');
		$i=0;
		foreach ($img_tags as $t )
		{
			if(isset($get_guid)){
				$savepath = $get_guid[$i][0]['guid'];	
				$t->setAttribute('src',$savepath);
				$i++;
			}
		}
		$result = $doc->saveHTML();
		$update_content['ID']           = $id;
		$update_content['post_content'] = $result;
		wp_update_post( $update_content );
	
		if($result){
			$wpdb->update( $wpdb->prefix . 'ultimate_csv_importer_shortcode_manager' , 
            array( 
                'status' => 'completed',
            ) , 
            array( 'post_id' => $id ,
                'image_shortcode' => 'inline'
            ) 
           );
			
		}
		return $id;
	}

	function import_core_fields($data_array, $mode = null, $line_number = null){
		$helpers_instance = ImportHelpers::getInstance();
	
			$data_array = $this->validateDate($data_array,$line_number,$mode);	
	
		if(!isset($data_array['post_author']) && $mode != 'Update') {
			$data_array['post_author'] = 1;
		} else {
			if(isset( $data_array['post_author'] )) {
				$user_records = $helpers_instance->get_from_user_details( $data_array['post_author'] );
				$data_array['post_author'] = $user_records['user_id'];
				$data_array['specific_author'] = $user_records['message'];
			}
		}
		if ( !empty($data_array['post_status']) ) {
			$data_array = $helpers_instance->assign_post_status( $data_array );
		}else{
			$data_array['post_status'] = 'publish';
		}
		return $data_array;
	}

	public function validateDate($data_array,$line_number,$mode) {

		if(!isset( $data_array['post_date'] )) {
			if($mode == 'insert'){
			$data_array['post_date'] = current_time('Y-m-d H:i:s');
			}
			else {
				//For update
				return $data_array;
			}
		} else {					
			//Validate the date
			if(strtotime( $data_array['post_date'] )) {	
				if(strtotime($data_array['post_date'])> 0)	
					$data_array['post_date'] = date( 'Y-m-d H:i:s', strtotime( $data_array['post_date'] ) );									
				else{
					if($data_array['post_date'] == '0000-00-00T00:00' || $data_array['post_date'] == '0000-00-00')
						$this->detailed_log[$line_number]["Message"] = "Skipped, Date format provided is wrong. Correct date format is 'YYYY-MM-DD' ";				
					else
						$data_array['post_date'] = current_time('Y-m-d H:i:s');
				}									
			} 
			else {				
				//check the date format as 18/05/2022 (valid)
				$data_array['post_date'] = str_replace('/', '-', $data_array['post_date']);
			
				if(!strtotime( $data_array['post_date'])){						
					//check the date format as mm-dd-yyyy (valid)
					$data_array['post_date'] = str_replace(array('.','-'), '/', $data_array['post_date']);
					
					if(!strtotime($data_array['post_date'])){							
						//Wrong format (Not valid date)		
						$this->detailed_log[$line_number]["Message"] = "Skipped, Date format provided is wrong. Correct date format is 'YYYY-MM-DD' ";						
					}
					else {
						$data_array['post_date'] = date( 'Y-m-d H:i:s', strtotime( $data_array['post_date'] ) );
					}								
				}
				else {					
					//Valid date
					$data_array['post_date'] = date( 'Y-m-d H:i:s', strtotime( $data_array['post_date'] ) );
				}
			}
		}		
		return $data_array;
	}

	public function custom_fields_update_based_on($update_based_on, $custom_array, $check, $header_array, $value_array){
		global $wpdb;		
		if(is_array($custom_array)){		
			foreach($custom_array as $custom_key => $custom_value){
				if (strpos($custom_value, '{') !== false && strpos($custom_value, '}') !== false) {
					$custom_value = $custom_key;
				}
				if($custom_key == $check){
					$get_key= array_search($custom_value , $header_array);
				}
				
				if(isset($get_key) && !empty($get_key) && isset($value_array[$get_key])) {
					$csv_element = $value_array[$get_key];	
				}
				if(!empty($csv_element) && ($update_based_on == 'acf' || $update_based_on == 'pods')){
					$get_result = $wpdb->get_results("SELECT post_id FROM {$wpdb->prefix}postmeta as a join {$wpdb->prefix}posts as b on a.post_id = b.ID WHERE a.meta_key = '$check' AND a.meta_value = '$csv_element' AND b.post_status != 'trash' order by a.post_id DESC ");					
				}				
				elseif(!empty($csv_element) && $update_based_on == 'toolset'){ 
					$meta_key = 'wpcf-'.$check;
					$get_result = $wpdb->get_results("SELECT post_id FROM {$wpdb->prefix}postmeta as a join {$wpdb->prefix}posts as b on a.post_id = b.ID WHERE a.meta_key = '$meta_key' AND a.meta_value = '$csv_element' AND b.post_status != 'trash' order by a.post_id DESC ");
				}
			}		
			if(empty($get_result)) {
				$this->detailed_log[$line_number]['Message'] = 'Skipped,Due to existing field value is not presents.';
			}				
			return $get_result;
		}		
	}

	public function post_format_function($post_id, $post_format_value){
		$format=str_replace("post-format-","",$post_format_value);
			set_post_format($post_id ,$format );
	}
	
	public function featured_image_handling($media_handle, $post_values, $post_id, $type, $get_import_type, $unikey_value, $unikey_name, $header_array, $value_array,$hash_key,$templatekey){		
		global $wpdb;
		//added this condition, bcoz header and value array are not available during images schedule - so storing those datas prior in db
		if($media_handle['media_settings']['media_handle_option'] == 'true' && !empty($post_values['featured_image']) && (!empty($media_handle['media_settings']['file_name']) || !empty($media_handle['media_settings']['alttext']) || !empty($media_handle['media_settings']['description']) || !empty($media_handle['media_settings']['caption']) || !empty($media_handle['media_settings']['title']))){
			$media_seo_array = [];
			$media_seo_array['header_array'] = $header_array;
			$media_seo_array['value_array'] = $value_array;
			update_option('smack_media_seo'.$unikey_value, $media_seo_array);
		}
		
		if($media_handle['media_settings']['use_ExistingImage'] == 'true'){
			$image_type = 'Featured';		
		
			$f_image = $post_values['featured_image'];
			if (strstr($f_image, 'https://drive.google.com')){
				preg_match('~/d/\K[^/]+(?=/)~', $f_image, $result_id);
				if(isset($result_id[0])){
					$fimg_name = $result_id[0];
				}
				else{
					$image_name = pathinfo($f_image);
					$fimg_name = $image_name['filename'];
				}
			}
			else{
				$image_name = pathinfo($f_image);
				$fimg_name = $image_name['filename'];
			}
			
			$check_featured_image = $wpdb->get_results("SELECT $unikey_name FROM {$wpdb->prefix}ultimate_csv_importer_media_report WHERE $unikey_name = '$unikey_value'  AND image_type = 'Featured' "); 
			if(empty($check_featured_image)){				
				$image_media_table = $wpdb->prefix . "ultimate_csv_importer_media_report";
				$wpdb->get_results("INSERT INTO $image_media_table (`hash_key`,`templatekey`,`module`,`image_type`,`status`) VALUES ( '{$hash_key}','{$templatekey}','{$type}','{$image_type}','Completed') ");
			}

			$wp_content_url = content_url();
			if(strpos($f_image, $wp_content_url) !== FALSE){
				$attachment_id = $wpdb->get_results("SELECT ID FROM {$wpdb->prefix}posts WHERE post_type = 'attachment' AND guid = '$f_image' ", ARRAY_A);
			}
			else{
				$attachment_id = $wpdb->get_results("SELECT ID FROM {$wpdb->prefix}posts WHERE post_type = 'attachment' AND guid LIKE '%$fimg_name%'", ARRAY_A);
			}

			if(!empty($attachment_id[0]['ID'])){
				set_post_thumbnail($post_id, $attachment_id[0]['ID'] );                
			}
			else{
				$shortcode_table = $wpdb->prefix . "ultimate_csv_importer_shortcode_manager";
				$original_featured_image = get_option('ultimate_csv_importer_pro_featured_image');
		
				if($post_id && ($post_id != 0) && !empty($original_featured_image)){
			
					$wpdb->insert($shortcode_table,
						array('image_shortcode' => 'featured_image',
									'original_image' => $original_featured_image,
									'post_id' => $post_id,
									$unikey_name => $unikey_value,
									'import_type' => $get_import_type
						),
						array('%s','%s','%d','%s','%s')
					);
				}	
				delete_option('ultimate_csv_importer_pro_featured_image');	

				$post_values['featured_image'] = WP_PLUGIN_URL . '/wp-ultimate-csv-importer-pro/assets/images/loading-image.jpg';	
				$image_type = 'Featured';		
				$attach_id = CoreFieldsImport::$media_instance->media_handling( $post_values['featured_image'] , $post_id ,$post_values,$type,$image_type,$unikey_value,$unikey_name,$header_array,$value_array);	
				set_post_thumbnail( $post_id, $attach_id );
			}
		}
		else{
			
			$image_type = 'Featured';	
			$check_featured_image = $wpdb->get_results("SELECT $unikey_name FROM {$wpdb->prefix}ultimate_csv_importer_media_report WHERE $unikey_name = '$unikey_value'  AND image_type = 'Featured' "); 
			if(empty($check_featured_image)){
				
				$image_media_table = $wpdb->prefix . "ultimate_csv_importer_media_report";
				$wpdb->get_results("INSERT INTO $image_media_table (`hash_key`,`templatekey`,`module`,`image_type`,`status`) VALUES ( '{$hash_key}','{$templatekey}','{$type}','{$image_type}','Completed') ");
			}
		
			$shortcode_table = $wpdb->prefix . "ultimate_csv_importer_shortcode_manager";
			$original_featured_image = get_option('ultimate_csv_importer_pro_featured_image');
	
			if($post_id && ($post_id != 0) && !empty($original_featured_image)){
				$wpdb->insert($shortcode_table,
					array('image_shortcode' => 'featured_image',
								'original_image' => $original_featured_image,
								'post_id' => $post_id,
								$unikey_name => $unikey_value,
								'import_type' => $get_import_type
					),
					array('%s','%s','%d','%s','%s')
				);
			}
			delete_option('ultimate_csv_importer_pro_featured_image');

			$post_values['featured_image'] = WP_PLUGIN_URL . '/wp-ultimate-csv-importer-pro/assets/images/loading-image.jpg';	
			$image_type = 'Featured';		
			$attach_id = CoreFieldsImport::$media_instance->media_handling( $post_values['featured_image'] , $post_id ,$post_values,$type,$image_type,$unikey_value,$unikey_name,$header_array,$value_array);	
			set_post_thumbnail( $post_id, $attach_id );
		}
		$attach_id=isset($attach_id)?$attach_id:'';
		return $attach_id;
	}

	public function check_for_featured_image_url($featured_image){
		if (strpos($featured_image, '|') !== false) {
			$featured_img = explode('|', $featured_image);
			$featured_image_url = $featured_img[0];					
		}
		else if (strpos($featured_image, ',') !== false) {
			$feature_img = explode(',', $featured_image);
			$featured_image_url = $feature_img[0];
		}
		else{
			$featured_image_url = $featured_image;
		}
		return $featured_image_url;
	}
}